<?php
/*--------------------------------------------------------------------
 WeightDto.php 2020-2-24
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Shop\Properties\SellingUnitWeight\Database\Repository\DTO;

/**
 * Class WeightDto
 * @package Gambio\Shop\Properties\SellingUnitWeight\Database\Repository\DTO
 */
class WeightDto
{
    /**
     * @var float
     */
    protected $weight;
    
    
    /**
     * WeightDto constructor.
     *
     * @param float $weight
     */
    public function __construct(float $weight)
    {
        $this->weight = $weight;
    }
    
    
    /**
     * @return float
     */
    public function weight(): float
    {
        return $this->weight;
    }
}